/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Injection flags for DI.
 *
 * @publicApi
 * @deprecated use an options object for [`inject`](api/core/inject) instead.
 */
export var InjectFlags;
(function (InjectFlags) {
    // TODO(alxhub): make this 'const' (and remove `InternalInjectFlags` enum) when ngc no longer
    // writes exports of it into ngfactory files.
    /** Check self and check parent injector if needed */
    InjectFlags[InjectFlags["Default"] = 0] = "Default";
    /**
     * Specifies that an injector should retrieve a dependency from any injector until reaching the
     * host element of the current component. (Only used with Element Injector)
     */
    InjectFlags[InjectFlags["Host"] = 1] = "Host";
    /** Don't ascend to ancestors of the node requesting injection. */
    InjectFlags[InjectFlags["Self"] = 2] = "Self";
    /** Skip the node that is requesting injection. */
    InjectFlags[InjectFlags["SkipSelf"] = 4] = "SkipSelf";
    /** Inject `defaultValue` instead if token not found. */
    InjectFlags[InjectFlags["Optional"] = 8] = "Optional";
})(InjectFlags || (InjectFlags = {}));
//# sourceMappingURL=data:application/json;base64,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