/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ɵɵinjectAttribute } from '../render3/instructions/di_attr';
import { makeParamDecorator } from '../util/decorators';
/**
 * Attribute decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Attribute = makeParamDecorator('Attribute', (attributeName) => ({
    attributeName,
    __NG_ELEMENT_ID__: () => ɵɵinjectAttribute(attributeName),
}));
//# sourceMappingURL=data:application/json;base64,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