/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from './injection_token';
/**
 * An internal token whose presence in an injector indicates that the injector should treat itself
 * as a root scoped injector when processing requests for unknown tokens which may indicate
 * they are provided in the root scope.
 */
export const INJECTOR_SCOPE = new InjectionToken(ngDevMode ? 'Set Injector scope.' : '');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NvcGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9jb3JlL3NyYy9kaS9zY29wZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFFSCxPQUFPLEVBQUMsY0FBYyxFQUFDLE1BQU0sbUJBQW1CLENBQUM7QUFJakQ7Ozs7R0FJRztBQUNILE1BQU0sQ0FBQyxNQUFNLGNBQWMsR0FBRyxJQUFJLGNBQWMsQ0FDOUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUN2QyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7SW5qZWN0aW9uVG9rZW59IGZyb20gJy4vaW5qZWN0aW9uX3Rva2VuJztcblxuZXhwb3J0IHR5cGUgSW5qZWN0b3JTY29wZSA9ICdyb290JyB8ICdwbGF0Zm9ybScgfCAnZW52aXJvbm1lbnQnO1xuXG4vKipcbiAqIEFuIGludGVybmFsIHRva2VuIHdob3NlIHByZXNlbmNlIGluIGFuIGluamVjdG9yIGluZGljYXRlcyB0aGF0IHRoZSBpbmplY3RvciBzaG91bGQgdHJlYXQgaXRzZWxmXG4gKiBhcyBhIHJvb3Qgc2NvcGVkIGluamVjdG9yIHdoZW4gcHJvY2Vzc2luZyByZXF1ZXN0cyBmb3IgdW5rbm93biB0b2tlbnMgd2hpY2ggbWF5IGluZGljYXRlXG4gKiB0aGV5IGFyZSBwcm92aWRlZCBpbiB0aGUgcm9vdCBzY29wZS5cbiAqL1xuZXhwb3J0IGNvbnN0IElOSkVDVE9SX1NDT1BFID0gbmV3IEluamVjdGlvblRva2VuPEluamVjdG9yU2NvcGUgfCBudWxsPihcbiAgbmdEZXZNb2RlID8gJ1NldCBJbmplY3RvciBzY29wZS4nIDogJycsXG4pO1xuIl19