/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// tslint:disable:no-duplicate-imports
import { EventContract, EventContractContainer, EventDispatcher, isEarlyEventType, getActionCache, registerDispatcher, } from '@angular/core/primitives/event-dispatch';
import { Attribute } from '@angular/core/primitives/event-dispatch';
import { Injectable, InjectionToken, inject } from './di';
import { EVENT_REPLAY_ENABLED_DEFAULT, IS_EVENT_REPLAY_ENABLED } from './hydration/tokens';
import * as i0 from "./r3_symbols";
export function invokeRegisteredListeners(event) {
    const handlerFns = event.currentTarget?.__jsaction_fns?.get(event.type);
    if (!handlerFns) {
        return;
    }
    for (const handler of handlerFns) {
        handler(event);
    }
}
export function setJSActionAttributes(nativeElement, eventTypes) {
    if (!eventTypes.length) {
        return;
    }
    const parts = eventTypes.reduce((prev, curr) => prev + curr + ':;', '');
    const existingAttr = nativeElement.getAttribute(Attribute.JSACTION);
    nativeElement.setAttribute(Attribute.JSACTION, `${existingAttr ?? ''}${parts}`);
}
export const sharedStashFunction = (rEl, eventType, listenerFn) => {
    const el = rEl;
    const eventListenerMap = el.__jsaction_fns ?? new Map();
    const eventListeners = eventListenerMap.get(eventType) ?? [];
    eventListeners.push(listenerFn);
    eventListenerMap.set(eventType, eventListeners);
    el.__jsaction_fns = eventListenerMap;
};
export const removeListeners = (el) => {
    el.removeAttribute(Attribute.JSACTION);
    el.__jsaction_fns = undefined;
};
export const JSACTION_EVENT_CONTRACT = new InjectionToken(ngDevMode ? 'EVENT_CONTRACT_DETAILS' : '', {
    providedIn: 'root',
    factory: () => ({}),
});
export const GLOBAL_EVENT_DELEGATION = new InjectionToken(ngDevMode ? 'GLOBAL_EVENT_DELEGATION' : '');
/**
 * This class is the delegate for `EventDelegationPlugin`. It represents the
 * noop version of this class, with the enabled version set when
 * `provideGlobalEventDelegation` is called.
 */
export class GlobalEventDelegation {
    constructor() {
        this.eventContractDetails = inject(JSACTION_EVENT_CONTRACT);
    }
    ngOnDestroy() {
        this.eventContractDetails.instance?.cleanUp();
    }
    supports(eventType) {
        return isEarlyEventType(eventType);
    }
    addEventListener(element, eventName, handler) {
        this.eventContractDetails.instance.addEvent(eventName);
        sharedStashFunction(element, eventName, handler);
        getActionCache(element)[eventName] = '';
        return () => this.removeEventListener(element, eventName, handler);
    }
    removeEventListener(element, eventType, callback) {
        getActionCache(element)[eventType] = undefined;
    }
    static { this.ɵfac = function GlobalEventDelegation_Factory(t) { return new (t || GlobalEventDelegation)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GlobalEventDelegation, factory: GlobalEventDelegation.ɵfac }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.setClassMetadata(GlobalEventDelegation, [{
        type: Injectable
    }], null, null); })();
export const initGlobalEventDelegation = (eventContractDetails, injector) => {
    if (injector.get(IS_EVENT_REPLAY_ENABLED, EVENT_REPLAY_ENABLED_DEFAULT)) {
        return;
    }
    const eventContract = (eventContractDetails.instance = new EventContract(new EventContractContainer(document.body)));
    const dispatcher = new EventDispatcher(invokeRegisteredListeners);
    registerDispatcher(eventContract, dispatcher);
};
//# sourceMappingURL=data:application/json;base64,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