/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/** Encodes that the node lookup should start from the host node of this component. */
export const REFERENCE_NODE_HOST = 'h';
/** Encodes that the node lookup should start from the document body node. */
export const REFERENCE_NODE_BODY = 'b';
/**
 * Describes navigation steps that the runtime logic need to perform,
 * starting from a given (known) element.
 */
export var NodeNavigationStep;
(function (NodeNavigationStep) {
    NodeNavigationStep["FirstChild"] = "f";
    NodeNavigationStep["NextSibling"] = "n";
})(NodeNavigationStep || (NodeNavigationStep = {}));
/**
 * Keys within serialized view data structure to represent various
 * parts. See the `SerializedView` interface below for additional information.
 */
export const ELEMENT_CONTAINERS = 'e';
export const TEMPLATES = 't';
export const CONTAINERS = 'c';
export const MULTIPLIER = 'x';
export const NUM_ROOT_NODES = 'r';
export const TEMPLATE_ID = 'i'; // as it's also an "id"
export const NODES = 'n';
export const DISCONNECTED_NODES = 'd';
export const I18N_DATA = 'l';
//# sourceMappingURL=data:application/json;base64,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