/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '../di/injection_token';
/**
 * Internal token that specifies whether DOM reuse logic
 * during hydration is enabled.
 */
export const IS_HYDRATION_DOM_REUSE_ENABLED = new InjectionToken(typeof ngDevMode === 'undefined' || !!ngDevMode ? 'IS_HYDRATION_DOM_REUSE_ENABLED' : '');
// By default (in client rendering mode), we remove all the contents
// of the host element and render an application after that.
export const PRESERVE_HOST_CONTENT_DEFAULT = false;
/**
 * Internal token that indicates whether host element content should be
 * retained during the bootstrap.
 */
export const PRESERVE_HOST_CONTENT = new InjectionToken(typeof ngDevMode === 'undefined' || !!ngDevMode ? 'PRESERVE_HOST_CONTENT' : '', {
    providedIn: 'root',
    factory: () => PRESERVE_HOST_CONTENT_DEFAULT,
});
/**
 * Internal token that indicates whether hydration support for i18n
 * is enabled.
 */
export const IS_I18N_HYDRATION_ENABLED = new InjectionToken(typeof ngDevMode === 'undefined' || !!ngDevMode ? 'IS_I18N_HYDRATION_ENABLED' : '');
/**
 * Internal token that indicates whether event replay support for SSR
 * is enabled.
 */
export const IS_EVENT_REPLAY_ENABLED = new InjectionToken(typeof ngDevMode === 'undefined' || !!ngDevMode ? 'IS_EVENT_REPLAY_ENABLED' : '');
export const EVENT_REPLAY_ENABLED_DEFAULT = false;
/**
 * Internal token that indicates whether global event delegation support is enabled.
 */
export const IS_GLOBAL_EVENT_DELEGATION_ENABLED = new InjectionToken(typeof ngDevMode === 'undefined' || !!ngDevMode ? 'IS_GLOBAL_EVENT_DELEGATION_ENABLED' : '');
//# sourceMappingURL=data:application/json;base64,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