/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @description
 *
 * Represents a type that a Component or other object is instances of.
 *
 * An example of a `Type` is `MyCustomComponent` class, which in JavaScript is represented by
 * the `MyCustomComponent` constructor function.
 *
 * @publicApi
 */
export const Type = Function;
export function isType(v) {
    return typeof v === 'function';
}
//# sourceMappingURL=data:application/json;base64,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