/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * This indirection is needed to free up Component, etc symbols in the public API
 * to be used by the decorator versions of these annotations.
 */
export { Attribute } from './di/metadata_attr';
export { ContentChild, ContentChildren, Query, ViewChild, ViewChildren, } from './metadata/di';
export { Component, Directive, HostBinding, HostListener, Input, Output, Pipe, } from './metadata/directives';
export { NgModule } from './metadata/ng_module';
export { CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA } from './metadata/schema';
export { ViewEncapsulation } from './metadata/view';
//# sourceMappingURL=data:application/json;base64,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