/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { compileNgModule } from '../render3/jit/module';
import { makeDecorator } from '../util/decorators';
/**
 * @Annotation
 */
export const NgModule = makeDecorator('NgModule', (ngModule) => ngModule, undefined, undefined, 
/**
 * Decorator that marks the following class as an NgModule, and supplies
 * configuration metadata for it.
 *
 * * The `declarations` option configures the compiler
 * with information about what belongs to the NgModule.
 * * The `providers` options configures the NgModule's injector to provide
 * dependencies the NgModule members.
 * * The `imports` and `exports` options bring in members from other modules, and make
 * this module's members available to others.
 */
(type, meta) => compileNgModule(type, meta));
//# sourceMappingURL=data:application/json;base64,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