/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
let _icuContainerIterate;
/**
 * Iterator which provides ability to visit all of the `TIcuContainerNode` root `RNode`s.
 */
export function icuContainerIterate(tIcuContainerNode, lView) {
    return _icuContainerIterate(tIcuContainerNode, lView);
}
/**
 * Ensures that `IcuContainerVisitor`'s implementation is present.
 *
 * This function is invoked when i18n instruction comes across an ICU. The purpose is to allow the
 * bundler to tree shake ICU logic and only load it if ICU instruction is executed.
 */
export function ensureIcuContainerVisitorLoaded(loader) {
    if (_icuContainerIterate === undefined) {
        // Do not inline this function. We want to keep `ensureIcuContainerVisitorLoaded` light, so it
        // can be inlined into call-site.
        _icuContainerIterate = loader();
    }
}
//# sourceMappingURL=data:application/json;base64,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