/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { SIGNAL } from '@angular/core/primitives/signals';
/**
 * Checks if the given `value` is a reactive `Signal`.
 */
export function isSignal(value) {
    return typeof value === 'function' && value[SIGNAL] !== undefined;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29yZS9zcmMvcmVuZGVyMy9yZWFjdGl2aXR5L2FwaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFFSCxPQUFPLEVBQUMsTUFBTSxFQUFDLE1BQU0sa0NBQWtDLENBQUM7QUFjeEQ7O0dBRUc7QUFDSCxNQUFNLFVBQVUsUUFBUSxDQUFDLEtBQWM7SUFDckMsT0FBTyxPQUFPLEtBQUssS0FBSyxVQUFVLElBQUssS0FBeUIsQ0FBQyxNQUFNLENBQUMsS0FBSyxTQUFTLENBQUM7QUFDekYsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge1NJR05BTH0gZnJvbSAnQGFuZ3VsYXIvY29yZS9wcmltaXRpdmVzL3NpZ25hbHMnO1xuXG4vKipcbiAqIEEgcmVhY3RpdmUgdmFsdWUgd2hpY2ggbm90aWZpZXMgY29uc3VtZXJzIG9mIGFueSBjaGFuZ2VzLlxuICpcbiAqIFNpZ25hbHMgYXJlIGZ1bmN0aW9ucyB3aGljaCByZXR1cm5zIHRoZWlyIGN1cnJlbnQgdmFsdWUuIFRvIGFjY2VzcyB0aGUgY3VycmVudCB2YWx1ZSBvZiBhIHNpZ25hbCxcbiAqIGNhbGwgaXQuXG4gKlxuICogT3JkaW5hcnkgdmFsdWVzIGNhbiBiZSB0dXJuZWQgaW50byBgU2lnbmFsYHMgd2l0aCB0aGUgYHNpZ25hbGAgZnVuY3Rpb24uXG4gKi9cbmV4cG9ydCB0eXBlIFNpZ25hbDxUPiA9ICgoKSA9PiBUKSAmIHtcbiAgW1NJR05BTF06IHVua25vd247XG59O1xuXG4vKipcbiAqIENoZWNrcyBpZiB0aGUgZ2l2ZW4gYHZhbHVlYCBpcyBhIHJlYWN0aXZlIGBTaWduYWxgLlxuICovXG5leHBvcnQgZnVuY3Rpb24gaXNTaWduYWwodmFsdWU6IHVua25vd24pOiB2YWx1ZSBpcyBTaWduYWw8dW5rbm93bj4ge1xuICByZXR1cm4gdHlwZW9mIHZhbHVlID09PSAnZnVuY3Rpb24nICYmICh2YWx1ZSBhcyBTaWduYWw8dW5rbm93bj4pW1NJR05BTF0gIT09IHVuZGVmaW5lZDtcbn1cblxuLyoqXG4gKiBBIGNvbXBhcmlzb24gZnVuY3Rpb24gd2hpY2ggY2FuIGRldGVybWluZSBpZiB0d28gdmFsdWVzIGFyZSBlcXVhbC5cbiAqL1xuZXhwb3J0IHR5cGUgVmFsdWVFcXVhbGl0eUZuPFQ+ID0gKGE6IFQsIGI6IFQpID0+IGJvb2xlYW47XG4iXX0=