/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/** Injection token to be used to override the default options for `mat-checkbox`. */
export const MAT_CHECKBOX_DEFAULT_OPTIONS = new InjectionToken('mat-checkbox-default-options', {
    providedIn: 'root',
    factory: MAT_CHECKBOX_DEFAULT_OPTIONS_FACTORY,
});
/** @docs-private */
export function MAT_CHECKBOX_DEFAULT_OPTIONS_FACTORY() {
    return {
        color: 'accent',
        clickAction: 'check-indeterminate',
    };
}
//# sourceMappingURL=data:application/json;base64,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