/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var MatTestDialogOpener_1;
import { __decorate, __metadata } from "tslib";
import { ChangeDetectionStrategy, Component, NgModule, NgZone, ViewEncapsulation, inject, } from '@angular/core';
import { MatDialog, MatDialogModule } from '@angular/material/dialog';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
/** Test component that immediately opens a dialog when bootstrapped. */
let MatTestDialogOpener = class MatTestDialogOpener {
    static { MatTestDialogOpener_1 = this; }
    /** Static method that prepares this class to open the provided component. */
    static withComponent(component, config) {
        MatTestDialogOpener_1.component = component;
        MatTestDialogOpener_1.config = config;
        return MatTestDialogOpener_1;
    }
    constructor(dialog) {
        this.dialog = dialog;
        this._ngZone = inject(NgZone);
        if (!MatTestDialogOpener_1.component) {
            throw new Error(`MatTestDialogOpener does not have a component provided.`);
        }
        this.dialogRef = this._ngZone.run(() => this.dialog.open(MatTestDialogOpener_1.component, MatTestDialogOpener_1.config || {}));
        this._afterClosedSubscription = this.dialogRef.afterClosed().subscribe(result => {
            this.closedResult = result;
        });
    }
    ngOnDestroy() {
        this._afterClosedSubscription.unsubscribe();
        MatTestDialogOpener_1.component = undefined;
        MatTestDialogOpener_1.config = undefined;
    }
};
MatTestDialogOpener = MatTestDialogOpener_1 = __decorate([
    Component({
        selector: 'mat-test-dialog-opener',
        template: '',
        changeDetection: ChangeDetectionStrategy.OnPush,
        encapsulation: ViewEncapsulation.None,
        standalone: true,
    }),
    __metadata("design:paramtypes", [MatDialog])
], MatTestDialogOpener);
export { MatTestDialogOpener };
let MatTestDialogOpenerModule = class MatTestDialogOpenerModule {
};
MatTestDialogOpenerModule = __decorate([
    NgModule({
        imports: [MatDialogModule, NoopAnimationsModule, MatTestDialogOpener],
    })
], MatTestDialogOpenerModule);
export { MatTestDialogOpenerModule };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGlhbG9nLW9wZW5lci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3NyYy9tYXRlcmlhbC9kaWFsb2cvdGVzdGluZy9kaWFsb2ctb3BlbmVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRzs7O0FBR0gsT0FBTyxFQUNMLHVCQUF1QixFQUN2QixTQUFTLEVBQ1QsUUFBUSxFQUNSLE1BQU0sRUFFTixpQkFBaUIsRUFDakIsTUFBTSxHQUNQLE1BQU0sZUFBZSxDQUFDO0FBQ3ZCLE9BQU8sRUFBQyxTQUFTLEVBQW1CLGVBQWUsRUFBZSxNQUFNLDBCQUEwQixDQUFDO0FBQ25HLE9BQU8sRUFBQyxvQkFBb0IsRUFBQyxNQUFNLHNDQUFzQyxDQUFDO0FBRzFFLHdFQUF3RTtBQVFqRSxJQUFNLG1CQUFtQixHQUF6QixNQUFNLG1CQUFtQjs7SUFpQjlCLDZFQUE2RTtJQUM3RSxNQUFNLENBQUMsYUFBYSxDQUNsQixTQUEyQixFQUMzQixNQUF3QjtRQUV4QixxQkFBbUIsQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO1FBQzFDLHFCQUFtQixDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7UUFDcEMsT0FBTyxxQkFBK0QsQ0FBQztJQUN6RSxDQUFDO0lBRUQsWUFBbUIsTUFBaUI7UUFBakIsV0FBTSxHQUFOLE1BQU0sQ0FBVztRQVpuQixZQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBYXhDLElBQUksQ0FBQyxxQkFBbUIsQ0FBQyxTQUFTLEVBQUUsQ0FBQztZQUNuQyxNQUFNLElBQUksS0FBSyxDQUFDLHlEQUF5RCxDQUFDLENBQUM7UUFDN0UsQ0FBQztRQUVELElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsR0FBRyxFQUFFLENBQ3JDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUNkLHFCQUFtQixDQUFDLFNBQTZCLEVBQ2pELHFCQUFtQixDQUFDLE1BQU0sSUFBSSxFQUFFLENBQ2pDLENBQ0YsQ0FBQztRQUNGLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFdBQVcsRUFBRSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsRUFBRTtZQUM5RSxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQztRQUM3QixDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCxXQUFXO1FBQ1QsSUFBSSxDQUFDLHdCQUF3QixDQUFDLFdBQVcsRUFBRSxDQUFDO1FBQzVDLHFCQUFtQixDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7UUFDMUMscUJBQW1CLENBQUMsTUFBTSxHQUFHLFNBQVMsQ0FBQztJQUN6QyxDQUFDO0NBQ0YsQ0FBQTtBQWhEWSxtQkFBbUI7SUFQL0IsU0FBUyxDQUFDO1FBQ1QsUUFBUSxFQUFFLHdCQUF3QjtRQUNsQyxRQUFRLEVBQUUsRUFBRTtRQUNaLGVBQWUsRUFBRSx1QkFBdUIsQ0FBQyxNQUFNO1FBQy9DLGFBQWEsRUFBRSxpQkFBaUIsQ0FBQyxJQUFJO1FBQ3JDLFVBQVUsRUFBRSxJQUFJO0tBQ2pCLENBQUM7cUNBNEIyQixTQUFTO0dBM0J6QixtQkFBbUIsQ0FnRC9COztBQUtNLElBQU0seUJBQXlCLEdBQS9CLE1BQU0seUJBQXlCO0NBQUcsQ0FBQTtBQUE1Qix5QkFBeUI7SUFIckMsUUFBUSxDQUFDO1FBQ1IsT0FBTyxFQUFFLENBQUMsZUFBZSxFQUFFLG9CQUFvQixFQUFFLG1CQUFtQixDQUFDO0tBQ3RFLENBQUM7R0FDVyx5QkFBeUIsQ0FBRyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge0NvbXBvbmVudFR5cGV9IGZyb20gJ0Bhbmd1bGFyL2Nkay9vdmVybGF5JztcbmltcG9ydCB7XG4gIENoYW5nZURldGVjdGlvblN0cmF0ZWd5LFxuICBDb21wb25lbnQsXG4gIE5nTW9kdWxlLFxuICBOZ1pvbmUsXG4gIE9uRGVzdHJveSxcbiAgVmlld0VuY2Fwc3VsYXRpb24sXG4gIGluamVjdCxcbn0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQge01hdERpYWxvZywgTWF0RGlhbG9nQ29uZmlnLCBNYXREaWFsb2dNb2R1bGUsIE1hdERpYWxvZ1JlZn0gZnJvbSAnQGFuZ3VsYXIvbWF0ZXJpYWwvZGlhbG9nJztcbmltcG9ydCB7Tm9vcEFuaW1hdGlvbnNNb2R1bGV9IGZyb20gJ0Bhbmd1bGFyL3BsYXRmb3JtLWJyb3dzZXIvYW5pbWF0aW9ucyc7XG5pbXBvcnQge1N1YnNjcmlwdGlvbn0gZnJvbSAncnhqcyc7XG5cbi8qKiBUZXN0IGNvbXBvbmVudCB0aGF0IGltbWVkaWF0ZWx5IG9wZW5zIGEgZGlhbG9nIHdoZW4gYm9vdHN0cmFwcGVkLiAqL1xuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAnbWF0LXRlc3QtZGlhbG9nLW9wZW5lcicsXG4gIHRlbXBsYXRlOiAnJyxcbiAgY2hhbmdlRGV0ZWN0aW9uOiBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneS5PblB1c2gsXG4gIGVuY2Fwc3VsYXRpb246IFZpZXdFbmNhcHN1bGF0aW9uLk5vbmUsXG4gIHN0YW5kYWxvbmU6IHRydWUsXG59KVxuZXhwb3J0IGNsYXNzIE1hdFRlc3REaWFsb2dPcGVuZXI8VCA9IHVua25vd24sIFIgPSB1bmtub3duPiBpbXBsZW1lbnRzIE9uRGVzdHJveSB7XG4gIC8qKiBDb21wb25lbnQgdGhhdCBzaG91bGQgYmUgb3BlbmVkIHdpdGggdGhlIE1hdERpYWxvZyBgb3BlbmAgbWV0aG9kLiAqL1xuICBwcm90ZWN0ZWQgc3RhdGljIGNvbXBvbmVudDogQ29tcG9uZW50VHlwZTx1bmtub3duPiB8IHVuZGVmaW5lZDtcblxuICAvKiogQ29uZmlnIHRoYXQgc2hvdWxkIGJlIHByb3ZpZGVkIHRvIHRoZSBNYXREaWFsb2cgYG9wZW5gIG1ldGhvZC4gKi9cbiAgcHJvdGVjdGVkIHN0YXRpYyBjb25maWc6IE1hdERpYWxvZ0NvbmZpZyB8IHVuZGVmaW5lZDtcblxuICAvKiogTWF0RGlhbG9nUmVmIHJldHVybmVkIGZyb20gdGhlIE1hdERpYWxvZyBgb3BlbmAgbWV0aG9kLiAqL1xuICBkaWFsb2dSZWY6IE1hdERpYWxvZ1JlZjxULCBSPjtcblxuICAvKiogRGF0YSBwYXNzZWQgdG8gdGhlIGBNYXREaWFsb2dgIGNsb3NlIG1ldGhvZC4gKi9cbiAgY2xvc2VkUmVzdWx0OiBSIHwgdW5kZWZpbmVkO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgX2FmdGVyQ2xvc2VkU3Vic2NyaXB0aW9uOiBTdWJzY3JpcHRpb247XG5cbiAgcHJpdmF0ZSByZWFkb25seSBfbmdab25lID0gaW5qZWN0KE5nWm9uZSk7XG5cbiAgLyoqIFN0YXRpYyBtZXRob2QgdGhhdCBwcmVwYXJlcyB0aGlzIGNsYXNzIHRvIG9wZW4gdGhlIHByb3ZpZGVkIGNvbXBvbmVudC4gKi9cbiAgc3RhdGljIHdpdGhDb21wb25lbnQ8VCA9IHVua25vd24sIFIgPSB1bmtub3duPihcbiAgICBjb21wb25lbnQ6IENvbXBvbmVudFR5cGU8VD4sXG4gICAgY29uZmlnPzogTWF0RGlhbG9nQ29uZmlnLFxuICApIHtcbiAgICBNYXRUZXN0RGlhbG9nT3BlbmVyLmNvbXBvbmVudCA9IGNvbXBvbmVudDtcbiAgICBNYXRUZXN0RGlhbG9nT3BlbmVyLmNvbmZpZyA9IGNvbmZpZztcbiAgICByZXR1cm4gTWF0VGVzdERpYWxvZ09wZW5lciBhcyBDb21wb25lbnRUeXBlPE1hdFRlc3REaWFsb2dPcGVuZXI8VCwgUj4+O1xuICB9XG5cbiAgY29uc3RydWN0b3IocHVibGljIGRpYWxvZzogTWF0RGlhbG9nKSB7XG4gICAgaWYgKCFNYXRUZXN0RGlhbG9nT3BlbmVyLmNvbXBvbmVudCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBNYXRUZXN0RGlhbG9nT3BlbmVyIGRvZXMgbm90IGhhdmUgYSBjb21wb25lbnQgcHJvdmlkZWQuYCk7XG4gICAgfVxuXG4gICAgdGhpcy5kaWFsb2dSZWYgPSB0aGlzLl9uZ1pvbmUucnVuKCgpID0+XG4gICAgICB0aGlzLmRpYWxvZy5vcGVuPFQsIFI+KFxuICAgICAgICBNYXRUZXN0RGlhbG9nT3BlbmVyLmNvbXBvbmVudCBhcyBDb21wb25lbnRUeXBlPFQ+LFxuICAgICAgICBNYXRUZXN0RGlhbG9nT3BlbmVyLmNvbmZpZyB8fCB7fSxcbiAgICAgICksXG4gICAgKTtcbiAgICB0aGlzLl9hZnRlckNsb3NlZFN1YnNjcmlwdGlvbiA9IHRoaXMuZGlhbG9nUmVmLmFmdGVyQ2xvc2VkKCkuc3Vic2NyaWJlKHJlc3VsdCA9PiB7XG4gICAgICB0aGlzLmNsb3NlZFJlc3VsdCA9IHJlc3VsdDtcbiAgICB9KTtcbiAgfVxuXG4gIG5nT25EZXN0cm95KCkge1xuICAgIHRoaXMuX2FmdGVyQ2xvc2VkU3Vic2NyaXB0aW9uLnVuc3Vic2NyaWJlKCk7XG4gICAgTWF0VGVzdERpYWxvZ09wZW5lci5jb21wb25lbnQgPSB1bmRlZmluZWQ7XG4gICAgTWF0VGVzdERpYWxvZ09wZW5lci5jb25maWcgPSB1bmRlZmluZWQ7XG4gIH1cbn1cblxuQE5nTW9kdWxlKHtcbiAgaW1wb3J0czogW01hdERpYWxvZ01vZHVsZSwgTm9vcEFuaW1hdGlvbnNNb2R1bGUsIE1hdFRlc3REaWFsb2dPcGVuZXJdLFxufSlcbmV4cG9ydCBjbGFzcyBNYXRUZXN0RGlhbG9nT3BlbmVyTW9kdWxlIHt9XG4iXX0=