/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/**
 * Thumb types: range slider has two thumbs (START, END) whereas single point
 * slider only has one thumb (END).
 */
export var _MatThumb;
(function (_MatThumb) {
    _MatThumb[_MatThumb["START"] = 1] = "START";
    _MatThumb[_MatThumb["END"] = 2] = "END";
})(_MatThumb || (_MatThumb = {}));
/** Tick mark enum, for discrete sliders. */
export var _MatTickMark;
(function (_MatTickMark) {
    _MatTickMark[_MatTickMark["ACTIVE"] = 0] = "ACTIVE";
    _MatTickMark[_MatTickMark["INACTIVE"] = 1] = "INACTIVE";
})(_MatTickMark || (_MatTickMark = {}));
/**
 * Injection token that can be used for a `MatSlider` to provide itself as a
 * parent to the `MatSliderThumb` and `MatSliderRangeThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER = new InjectionToken('_MatSlider');
/**
 * Injection token that can be used to query for a `MatSliderThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER_THUMB = new InjectionToken('_MatSliderThumb');
/**
 * Injection token that can be used to query for a `MatSliderRangeThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER_RANGE_THUMB = new InjectionToken('_MatSliderRangeThumb');
/**
 * Injection token that can be used to query for a `MatSliderVisualThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER_VISUAL_THUMB = new InjectionToken('_MatSliderVisualThumb');
/**
 * A simple change event emitted by the MatSlider component.
 * @deprecated Use event bindings directly on the MatSliderThumbs for `change` and `input` events. See https://v17.material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
export class MatSliderChange {
}
//# sourceMappingURL=data:application/json;base64,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