/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { bootstrapApplication, BrowserModule, createApplication, platformBrowser, provideProtractorTestingSupport, } from './browser';
export { Meta } from './browser/meta';
export { Title } from './browser/title';
export { disableDebugTools, enableDebugTools } from './browser/tools/tools';
export { By } from './dom/debug/by';
export { REMOVE_STYLES_ON_COMPONENT_DESTROY } from './dom/dom_renderer';
export { EVENT_MANAGER_PLUGINS, EventManager, EventManagerPlugin } from './dom/events/event_manager';
export { HAMMER_GESTURE_CONFIG, HAMMER_LOADER, HammerGestureConfig, HammerModule, } from './dom/events/hammer_gestures';
export { DomSanitizer, } from './security/dom_sanitization_service';
export { HydrationFeatureKind, provideClientHydration, withEventReplay, withHttpTransferCacheOptions, withI18nSupport, withNoHttpTransferCache, } from './hydration';
export * from './private_export';
export { VERSION } from './version';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGxhdGZvcm0tYnJvd3Nlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL3BsYXRmb3JtLWJyb3dzZXIvc3JjL3BsYXRmb3JtLWJyb3dzZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBRUgsT0FBTyxFQUVMLG9CQUFvQixFQUNwQixhQUFhLEVBQ2IsaUJBQWlCLEVBQ2pCLGVBQWUsRUFDZiwrQkFBK0IsR0FDaEMsTUFBTSxXQUFXLENBQUM7QUFDbkIsT0FBTyxFQUFDLElBQUksRUFBaUIsTUFBTSxnQkFBZ0IsQ0FBQztBQUNwRCxPQUFPLEVBQUMsS0FBSyxFQUFDLE1BQU0saUJBQWlCLENBQUM7QUFDdEMsT0FBTyxFQUFDLGlCQUFpQixFQUFFLGdCQUFnQixFQUFDLE1BQU0sdUJBQXVCLENBQUM7QUFDMUUsT0FBTyxFQUFDLEVBQUUsRUFBQyxNQUFNLGdCQUFnQixDQUFDO0FBQ2xDLE9BQU8sRUFBQyxrQ0FBa0MsRUFBQyxNQUFNLG9CQUFvQixDQUFDO0FBQ3RFLE9BQU8sRUFBQyxxQkFBcUIsRUFBRSxZQUFZLEVBQUUsa0JBQWtCLEVBQUMsTUFBTSw0QkFBNEIsQ0FBQztBQUNuRyxPQUFPLEVBQ0wscUJBQXFCLEVBQ3JCLGFBQWEsRUFDYixtQkFBbUIsRUFFbkIsWUFBWSxHQUNiLE1BQU0sOEJBQThCLENBQUM7QUFDdEMsT0FBTyxFQUNMLFlBQVksR0FPYixNQUFNLHFDQUFxQyxDQUFDO0FBQzdDLE9BQU8sRUFFTCxvQkFBb0IsRUFDcEIsc0JBQXNCLEVBQ3RCLGVBQWUsRUFDZiw0QkFBNEIsRUFDNUIsZUFBZSxFQUNmLHVCQUF1QixHQUN4QixNQUFNLGFBQWEsQ0FBQztBQUVyQixjQUFjLGtCQUFrQixDQUFDO0FBQ2pDLE9BQU8sRUFBQyxPQUFPLEVBQUMsTUFBTSxXQUFXLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuZXhwb3J0IHtcbiAgQXBwbGljYXRpb25Db25maWcsXG4gIGJvb3RzdHJhcEFwcGxpY2F0aW9uLFxuICBCcm93c2VyTW9kdWxlLFxuICBjcmVhdGVBcHBsaWNhdGlvbixcbiAgcGxhdGZvcm1Ccm93c2VyLFxuICBwcm92aWRlUHJvdHJhY3RvclRlc3RpbmdTdXBwb3J0LFxufSBmcm9tICcuL2Jyb3dzZXInO1xuZXhwb3J0IHtNZXRhLCBNZXRhRGVmaW5pdGlvbn0gZnJvbSAnLi9icm93c2VyL21ldGEnO1xuZXhwb3J0IHtUaXRsZX0gZnJvbSAnLi9icm93c2VyL3RpdGxlJztcbmV4cG9ydCB7ZGlzYWJsZURlYnVnVG9vbHMsIGVuYWJsZURlYnVnVG9vbHN9IGZyb20gJy4vYnJvd3Nlci90b29scy90b29scyc7XG5leHBvcnQge0J5fSBmcm9tICcuL2RvbS9kZWJ1Zy9ieSc7XG5leHBvcnQge1JFTU9WRV9TVFlMRVNfT05fQ09NUE9ORU5UX0RFU1RST1l9IGZyb20gJy4vZG9tL2RvbV9yZW5kZXJlcic7XG5leHBvcnQge0VWRU5UX01BTkFHRVJfUExVR0lOUywgRXZlbnRNYW5hZ2VyLCBFdmVudE1hbmFnZXJQbHVnaW59IGZyb20gJy4vZG9tL2V2ZW50cy9ldmVudF9tYW5hZ2VyJztcbmV4cG9ydCB7XG4gIEhBTU1FUl9HRVNUVVJFX0NPTkZJRyxcbiAgSEFNTUVSX0xPQURFUixcbiAgSGFtbWVyR2VzdHVyZUNvbmZpZyxcbiAgSGFtbWVyTG9hZGVyLFxuICBIYW1tZXJNb2R1bGUsXG59IGZyb20gJy4vZG9tL2V2ZW50cy9oYW1tZXJfZ2VzdHVyZXMnO1xuZXhwb3J0IHtcbiAgRG9tU2FuaXRpemVyLFxuICBTYWZlSHRtbCxcbiAgU2FmZVJlc291cmNlVXJsLFxuICBTYWZlU2NyaXB0LFxuICBTYWZlU3R5bGUsXG4gIFNhZmVVcmwsXG4gIFNhZmVWYWx1ZSxcbn0gZnJvbSAnLi9zZWN1cml0eS9kb21fc2FuaXRpemF0aW9uX3NlcnZpY2UnO1xuZXhwb3J0IHtcbiAgSHlkcmF0aW9uRmVhdHVyZSxcbiAgSHlkcmF0aW9uRmVhdHVyZUtpbmQsXG4gIHByb3ZpZGVDbGllbnRIeWRyYXRpb24sXG4gIHdpdGhFdmVudFJlcGxheSxcbiAgd2l0aEh0dHBUcmFuc2ZlckNhY2hlT3B0aW9ucyxcbiAgd2l0aEkxOG5TdXBwb3J0LFxuICB3aXRoTm9IdHRwVHJhbnNmZXJDYWNoZSxcbn0gZnJvbSAnLi9oeWRyYXRpb24nO1xuXG5leHBvcnQgKiBmcm9tICcuL3ByaXZhdGVfZXhwb3J0JztcbmV4cG9ydCB7VkVSU0lPTn0gZnJvbSAnLi92ZXJzaW9uJztcbiJdfQ==