/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { createUrlTreeFromSnapshot } from './create_url_tree';
export { RouterLink, RouterLinkWithHref } from './directives/router_link';
export { RouterLinkActive } from './directives/router_link_active';
export { RouterOutlet } from './directives/router_outlet';
export { ActivationEnd, ActivationStart, ChildActivationEnd, ChildActivationStart, EventType, GuardsCheckEnd, GuardsCheckStart, NavigationCancel, NavigationCancellationCode as NavigationCancellationCode, NavigationEnd, NavigationError, NavigationSkipped, NavigationSkippedCode, NavigationStart, ResolveEnd, ResolveStart, RouteConfigLoadEnd, RouteConfigLoadStart, RouterEvent, RoutesRecognized, Scroll, } from './events';
export { RedirectCommand, } from './models';
export * from './models_deprecated';
export { DefaultTitleStrategy, TitleStrategy } from './page_title_strategy';
export { withViewTransitions, provideRouter, provideRoutes, withComponentInputBinding, withDebugTracing, withDisabledInitialNavigation, withEnabledBlockingInitialNavigation, withHashLocation, withInMemoryScrolling, withNavigationErrorHandler, withPreloading, withRouterConfig, } from './provide_router';
export { BaseRouteReuseStrategy, RouteReuseStrategy, } from './route_reuse_strategy';
export { Router } from './router';
export { ROUTER_CONFIGURATION, } from './router_config';
export { ROUTES } from './router_config_loader';
export { ROUTER_INITIALIZER, RouterModule } from './router_module';
export { ChildrenOutletContexts, OutletContext } from './router_outlet_context';
export { NoPreloading, PreloadAllModules, PreloadingStrategy, RouterPreloader, } from './router_preloader';
export { ActivatedRoute, ActivatedRouteSnapshot, RouterState, RouterStateSnapshot, } from './router_state';
export { convertToParamMap, defaultUrlMatcher, PRIMARY_OUTLET } from './shared';
export { UrlHandlingStrategy } from './url_handling_strategy';
export { DefaultUrlSerializer, UrlSegment, UrlSegmentGroup, UrlSerializer, UrlTree, } from './url_tree';
export { mapToCanActivate, mapToCanActivateChild, mapToCanDeactivate, mapToCanMatch, mapToResolve, } from './utils/functional_guards';
export { VERSION } from './version';
export * from './private_export';
//# sourceMappingURL=data:application/json;base64,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