/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { combineLatest } from 'rxjs';
import { filter, map, startWith, switchMap, take } from 'rxjs/operators';
import { RedirectCommand } from '../models';
import { isUrlTree } from '../url_tree';
const INITIAL_VALUE = /* @__PURE__ */ Symbol('INITIAL_VALUE');
export function prioritizedGuardValue() {
    return switchMap((obs) => {
        return combineLatest(obs.map((o) => o.pipe(take(1), startWith(INITIAL_VALUE)))).pipe(map((results) => {
            for (const result of results) {
                if (result === true) {
                    // If result is true, check the next one
                    continue;
                }
                else if (result === INITIAL_VALUE) {
                    // If guard has not finished, we need to stop processing.
                    return INITIAL_VALUE;
                }
                else if (result === false || isRedirect(result)) {
                    // Result finished and was not true. Return the result.
                    // Note that we only allow false/UrlTree/RedirectCommand. Other values are considered invalid and
                    // ignored.
                    return result;
                }
            }
            // Everything resolved to true. Return true.
            return true;
        }), filter((item) => item !== INITIAL_VALUE), take(1));
    });
}
function isRedirect(val) {
    return isUrlTree(val) || val instanceof RedirectCommand;
}
//# sourceMappingURL=data:application/json;base64,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