"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultTheme = void 0;
const picocolors_1 = __importDefault(require("picocolors"));
const cli_spinners_1 = __importDefault(require("cli-spinners"));
exports.defaultTheme = {
    prefix: picocolors_1.default.green('?'),
    spinner: {
        interval: cli_spinners_1.default.dots.interval,
        frames: cli_spinners_1.default.dots.frames.map((frame) => picocolors_1.default.yellow(frame)),
    },
    style: {
        answer: picocolors_1.default.cyan,
        message: picocolors_1.default.bold,
        error: (text) => picocolors_1.default.red(`> ${text}`),
        defaultAnswer: (text) => picocolors_1.default.dim(`(${text})`),
        help: picocolors_1.default.dim,
        highlight: picocolors_1.default.cyan,
        key: (text) => picocolors_1.default.cyan(picocolors_1.default.bold(`<${text}>`)),
    },
};
