import pc from 'picocolors';
import spinners from 'cli-spinners';
export const defaultTheme = {
    prefix: pc.green('?'),
    spinner: {
        interval: spinners.dots.interval,
        frames: spinners.dots.frames.map((frame) => pc.yellow(frame)),
    },
    style: {
        answer: pc.cyan,
        message: pc.bold,
        error: (text) => pc.red(`> ${text}`),
        defaultAnswer: (text) => pc.dim(`(${text})`),
        help: pc.dim,
        highlight: pc.cyan,
        key: (text) => pc.cyan(pc.bold(`<${text}>`)),
    },
};
