import { Component, ViewChild } from '@angular/core';
import { RouterOutlet } from '@angular/router';
import { HeaderComponent } from './header/header.component';
import { BroadcastService, ClaveEventos } from './servicios/broadcast.service';
import { MatSidenav, MatSidenavModule } from '@angular/material/sidenav'
import * as _ from 'underscore';
import { LoginComponent } from './login/login.component';

@Component({
  selector: 'app-root',
  standalone: true,
  imports: [RouterOutlet, HeaderComponent, MatSidenav,
		 MatSidenavModule, LoginComponent],
  providers: [ BroadcastService ],
  templateUrl: './app.component.html',
  styleUrl: './app.component.scss'
})
export class AppComponent {
	title = 'libros';

	@ViewChild("sidenav") sidenav: MatSidenav | null = null;

	constructor(broadCast: BroadcastService) {
		_.bindAll(this, "onLoginClicked", "onLoginEvento");
		broadCast.on(ClaveEventos.CLICK_BOTON_LOGIN)
				.subscribe(this.onLoginClicked);
                broadCast.on(ClaveEventos.EVENTO_USER_LOGIN)
                                .subscribe(this.onLoginEvento);
	}

	onLoginClicked(ev: string) {
		console.log(`AppComponent recibio: ${ev}`);
		this.sidenav?.open();
	}

	onLoginEvento() {
		this.sidenav?.close();
	}
}
