import { Component, OnInit, EventEmitter } from '@angular/core';
import { MatIconModule } from '@angular/material/icon';
import { CommonModule } from '@angular/common';
import { BroadcastService, ClaveEventos } from '../servicios/broadcast.service';
import * as _ from 'underscore';

@Component({
  selector: 'app-detalles-user',
  standalone: true,
  imports: [MatIconModule, CommonModule],
  templateUrl: './detalles-user.component.html',
  styleUrl: './detalles-user.component.scss'
})

export class DetallesUserComponent implements OnInit {
	nombreUser: string = "";
	estaDentro: boolean = false;
	constructor(private broadCast: BroadcastService) {
		_.bindAll(this,"loginExitoso");
		this.broadCast.on(ClaveEventos.EVENTO_USER_LOGIN)
				.subscribe(this.loginExitoso);
	}

	ngOnInit(): void {}

	entrar(){
		console.log(`DetallesUserComponent : entrar()`);
		this.broadCast.broadcast(ClaveEventos.CLICK_BOTON_LOGIN,
				"DetallesUserComponent: CLICK_BOTON_LOGIN");
	}

	loginExitoso(ev: any): void {
		console.log(`DetallesUserComponent.loginExitoso: ${ev}`);
		this.nombreUser = ev;
		this.estaDentro = true;
	}

	salir(): void {
		this.nombreUser = "";
		this.estaDentro = false;
	}
}
