import { Component, OnInit } from '@angular/core';
import { FormBuilder,FormControl,FormGroup,Validators } from '@angular/forms';
import { BroadcastService,ClaveEventos } from '../servicios/broadcast.service';
import { CommonModule } from '@angular/common';
import { ReactiveFormsModule } from '@angular/forms';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatInputModule } from '@angular/material/input';
import { MatButtonModule } from '@angular/material/button';

@Component({
  selector: 'app-login',
  standalone: true,
  imports: [ReactiveFormsModule, MatFormFieldModule,
		CommonModule, MatInputModule,MatButtonModule],
  templateUrl: './login.component.html',
  styleUrl: './login.component.scss'
})

export class LoginComponent implements OnInit {
	loginForm: FormGroup | null = null;

	constructor( 
		private formBuilder: FormBuilder,
		private broadCast: BroadcastService) {}

	ngOnInit(): void {
		this.buildForm();
	}

	buildForm() {
	  let form = {
		usuario: new FormControl({}, Validators.required),
		password: new FormControl({}, Validators.required)
	  }
	  let formEstado = {
		usuario: {
			value: "",
			disabled: false
		},
		password: {
			value: "",
			disabled: false
		}
	  }
	  this.loginForm = this.formBuilder.group(form);
	  this.loginForm.reset(formEstado);
	}

	esValido() {
		return this.loginForm?.valid;
	}

	onSubmit() {
          console.log(`onSubmit: usuario : ${this.loginForm?.value.usuario}`);
          console.log(`onSubmit: password : ${this.loginForm?.value.password}`);

          this.broadCast.broadcast(
		ClaveEventos.EVENTO_USER_LOGIN,
		this.loginForm?.value.usuario);
	}
}
