import { Injectable } from '@angular/core';
import { Observable, Subject } from 'rxjs';
import { filter, map } from 'rxjs/operators';

export interface IEventoBroadcast {
	clave: ClaveEventos;
	datos?: any;
}

export enum ClaveEventos {
	TODOS = "Todos los eventos",
	CLICK_BOTON_LOGIN = "click_boton_login",
	EVENTO_USER_LOGIN = "evento_user_login"
}

@Injectable({
  providedIn: 'root'
})

export class BroadcastService {
	private busEvento = new Subject<IEventoBroadcast>();

	broadcast(clave: ClaveEventos, datos: string) {
		this.busEvento.next({clave, datos});
	}

	on(clave: ClaveEventos): Observable<string> {
		return this.busEvento.asObservable().pipe(
			filter(ev => ev.clave === clave ||
				ev.clave === ClaveEventos.TODOS),
				map(ev => ev.datos));
	}
}
